<?php

namespace Ttc\Freebies\Intervention\Image\Imagick\Commands;

class HeightenCommand extends \Ttc\Freebies\Intervention\Image\Imagick\Commands\ResizeCommand
{
    /**
     * Resize image proportionally to given height
     *
     * @param \Ttc\Freebies\Intervention\Image\Image $image
     * @return boolean
     */
    public function execute($image)
    {
        $height = $this->argument(0)->type('digit')->required()->value();
        $additionalConstraints = $this->argument(1)->type('closure')->value();

        $this->arguments[0] = null;
        $this->arguments[1] = $height;
        $this->arguments[2] = function ($constraint) use ($additionalConstraints) {
            $constraint->aspectRatio();
            if(is_callable($additionalConstraints))
                $additionalConstraints($constraint);
        };

        return parent::execute($image);
    }
}
